#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.12.0
 Author:        Xandy
				Code Wheel Data from: http://eab.abime.net/showpost.php?p=263214&postcount=9
				Deciphered by Ruby.

 Script Function:
	Waxworks Code Wheel Code Breaker

#ce ----------------------------------------------------------------------------
; Include
#include <GUIConstants.au3>
#include <GuiComboBox.au3>
#include <Misc.au3>
#include <GuiImageList.au3>
#include <GuiComboBoxEx.au3>
#include <WinAPIConstants.au3>

#include "Include\SDL v14\SDL.au3";AdmiralAlkex
#include "Include\SDL v14\SDL_Image.au3";AdmiralAlkex
#include "Include\SDL v14\SDL_sge.au3";AdmiralAlkex
#include "Include\SDL v14\SDL_sprig.au3";AdmiralAlkex

; Global
global $debug_songersoft= 0

; Magnifier
global $mousepo= 0
global $magnifier= 0
global $magnifier_surf= 0
global $magnifier_w= 150, $magnifier_h= 100

; Wheel Diagram
global $wheel_diagram_rect= 0
global $screen= 0
global $wheel_surf, $wheel_surf_a= 0
global $wheel_cur= 0
global $wheel_max= 3
global $mouse_drag= 0
global $mouse_coord
global $mouse_moved= 0
global $code_x_max= 12, $code_y_max= 6, $code_layer_max= 2
global $wheel_code[$code_x_max][$code_y_max][$code_layer_max]
enum $code_wheel_monster, $code_wheel_symbol

global $index_chart_max= 16, $index_chart_data_max= 2
global $index_chart[$index_chart_max][$index_chart_data_max]

global $wheel_pic_data_max= 12
global $wheel_pic[$wheel_max][$wheel_pic_data_max]
enum $wp_surf, $wp_x, $wp_y, $wp_w, $wp_h, $wp_rotate, $wp_rotate_new, $wp_name_label, $wp_wheel_diagram_color, $wp_spin, $wp_spin_to, $wp_last_id
local $redraw= 1
global $hgui= 0, $hgui_rect= 0
global $gui_control_max= 17
global $gui_control[$gui_control_max]
enum $gc_symbol_comboex, $gc_monster_comboex, $gc_location_combo, $gc_item_combo, $gc_seek_button, $gc_rotate_left_button, $gc_rotate_right_button, $gc_rotate_input, $gc_wheel_diagram_label, _;9
											$gc_rotate_wheel_surf_left_button, $gc_rotate_wheel_surf_right_button, $gc_rotate_wheel_surf_input, $gc_magnifier_button, _; 13
											$gc_move_left_button, $gc_move_right_button, $gc_move_up_button, $gc_move_down_button

Global $pStub_MouseProc = DllCallbackRegister ("_Mouse_Handler", "int", "int;ptr;ptr")
Global $hHookMouse = _WinAPI_SetWindowsHookEx($WH_MOUSE_LL, DllCallbackGetPtr($pStub_MouseProc), _WinAPI_GetModuleHandle(0), 0)

Global $iDecimal= 2
; Global End

main()
func main()
	local $mouse_clicked_over_wheel= 0
	local $mouse_right_clicked_over_wheel= 0
	local $surf_scaled= 0
	local $magnifier_cooldown= 0

	$hgui= guicreate("Waxworks Code-Wheel", 800, 600, default, default)
	$hgui_rect= wingetpos($hgui)
	if $debug_songersoft= 0 then EnvSet("SDL_WINDOWID", $hgui);remark this to create AutoIt window and recieve error messages from AutoIt
	; Init
	opt("GUICloseOnESC", 0)
	opt("MouseCoordMode", 2)
	_SDL_Init_image();load png file type
	_SDL_Startup_sge();rotation, flipping, and scaleing
	_SDL_Startup_sprig();read pixel colors
	_SDL_Init($_SDL_INIT_VIDEO)
	$screen= _SDL_SetVideoMode($hgui_rect[2], $hgui_rect[3], 32, $_SDL_SWSURFACE)
	creategui()
	GUIRegisterMsg($WM_COMMAND, "MY_WM_COMMAND")
	code_load()
	$wheel_diagram_rect= _SDL_Rect_Create($hgui_rect[2]-173, 0, 148, 100)

	wheel_diagram_draw()

	$wheel_surf= _SDL_DisplayFormat($wheel_pic[0][$wp_surf])
	$magnifier_surf= _SDL_CreateRGBSurface($_SDL_SWSURFACE, $magnifier_w, $magnifier_h, 32, 0, 0, 0, 0)
	$surf_scaled= _SDL_CreateRGBSurface($_SDL_SWSURFACE, $magnifier_w*2, $magnifier_h*2, 32, 0, 0, 0, 0)
	gui_control_show($gc_rotate_left_button, $gc_wheel_diagram_label)

	do
		if winactive($hgui) or $debug_songersoft= 1 then
			$msg= guigetmsg()
			switch $msg
				case $gui_control[$gc_seek_button]
					code_display()
				case $gui_control[$gc_location_combo]
					$wheel_pic[2][$wp_spin_to]= 360-(_GUICtrlComboBox_GetCurSel($gui_control[$gc_location_combo])*(360/$code_x_max))
					if $wheel_pic[2][$wp_spin_to]= 360 then $wheel_pic[2][$wp_spin_to]= 0
					$wheel_pic[2][$wp_spin]= 1
				case $gui_control[$gc_rotate_left_button]
					$wheel_pic[$wheel_cur][$wp_rotate]-= .5
					$redraw= 1
				case $gui_control[$gc_rotate_right_button]
					$wheel_pic[$wheel_cur][$wp_rotate]+= .5
					$redraw= 1
				case $gui_control[$gc_rotate_wheel_surf_left_button]
					$wheel_surf_a-= .5
					$redraw= 1
				case $gui_control[$gc_rotate_wheel_surf_right_button]
					$wheel_surf_a+= .5
					$redraw= 1
				case $gui_control[$gc_rotate_input]
					$wheel_pic[$wheel_cur][$wp_rotate]= guictrlread($gui_control[$gc_rotate_input])
					$redraw= 1
				case $gui_control[$gc_rotate_wheel_surf_input]
					$wheel_surf_a= guictrlread($gui_control[$gc_rotate_wheel_surf_input])
					$redraw= 1
				case $gui_control[$gc_magnifier_button]
					if timerdiff($magnifier_cooldown)> 500 then $magnifier= 1
					keyreleased(1)
				case $gui_control[$gc_move_up_button]
					$wheel_pic[$wheel_cur][$wp_y]+= 1
					$redraw= 1
				case $gui_control[$gc_move_down_button]
					$wheel_pic[$wheel_cur][$wp_y]-= 1
					$redraw= 1
				case $gui_control[$gc_move_left_button]
					$wheel_pic[$wheel_cur][$wp_x]+= 1
					$redraw= 1
				case $gui_control[$gc_move_right_button]
					$wheel_pic[$wheel_cur][$wp_x]-= 1
					$redraw= 1
			endswitch;$msg
			if $magnifier= 1 then
				$mousepo= mousegetpos()
				if mouseoverrect($wheel_pic[0][$wp_x], $wheel_pic[0][$wp_y], $wheel_pic[0][$wp_w], $wheel_pic[0][$wp_h]) then
					guictrlsetstate($gui_control[$gc_magnifier_button], $gui_hide)
					$srect= _SDL_Rect_Create($mousepo[0], $mousepo[1], $magnifier_w, $magnifier_h)
					_SDL_BlitSurface($wheel_surf, $srect, $magnifier_surf, 0)
					_sge_transform($magnifier_surf, $surf_scaled, 0, 2, 2, 0, 0, 0, 0, 0)
					$redraw= 2
				else
					guictrlsetstate($gui_control[$gc_magnifier_button], $gui_show)
					guictrlsetpos($gui_control[$gc_magnifier_button], $mousepo[0], $mousepo[1])
				endif
				if _ispressed(1) or _ispressed("1b") then; Escape
					keyreleased(1)
					guictrlsetpos($gui_control[$gc_magnifier_button], $hgui_rect[2]-100, 250)
					$magnifier= 0
					$redraw= 2
					$magnifier_cooldown= timerinit()
				endif
			endif;magnifier= 1
			if _ispressed(1) then; Left Mouse Button
				$mousepo= mousegetpos()
				if wheel_diagram_mouse_over()= 0 then
					if $mouse_clicked_over_wheel= 0 then; Select wheel by clicking over wheel graphic
						for $i= $wheel_max-1 to 0 step -1
							if mouseoverrect($wheel_pic[$i][$wp_x], $wheel_pic[$i][$wp_y], $wheel_pic[$i][$wp_w], $wheel_pic[$i][$wp_h])= 1 then
								$mouse_clicked_over_wheel= 1
								$redraw= 2
								$mousepo_last= mousegetpos()
								if _SPG_GetPixel($wheel_pic[$i][$wp_surf], $mousepo[0]-$wheel_pic[$i][$wp_x], $mousepo[1]-$wheel_pic[$i][$wp_y])<> 0 then;If Not transparent color
									$wheel_cur= $i
									exitloop
								endif
							endif;mouse over rect wheel
						next;i wheel
					else;drag<> 0
						wheel_drag($mousepo_last, 0)
					endif;drag= 0
				endif
			else; Mouse left button up
				$mouse_drag= 0
				$mouse_clicked_over_wheel= 0
				if _ispressed("2") then
					if $mouse_right_clicked_over_wheel= 0 then
						$mouse_right_clicked_over_wheel= 1
						$mousepo_last= mousegetpos()
					else
						wheel_drag($mousepo_last, 1)
					endif
				else
					$mouse_right_clicked_over_wheel= 0
				endif
			endif;_ispressed(1)

			wheel_seek_position()

			if $redraw> 0 then
				if $redraw= 2 then
					$drect= _SDL_Rect_Create(0, 0, $hgui_rect[2], $wheel_pic[0][$wp_h])
					_SDL_FillRect($screen, $drect, 0)
				endif

				guictrlsetdata($gui_control[$gc_rotate_input], $wheel_pic[$wheel_cur][$wp_rotate])
				guictrlsetdata($gui_control[$gc_rotate_wheel_surf_input], $wheel_surf_a)
				wheel_draw()
				if $magnifier= 1 then
					_SDL_BlitSurface($surf_scaled, 0, $screen, $srect)
				endif
				if $redraw= 2 then
					wheel_diagram_draw()
					_SDL_UpdateRect($screen, 0, 0, $hgui_rect[2], $wheel_pic[0][$wp_h])
					gui_control_show()
				else
					_SDL_UpdateRect($screen, $wheel_pic[0][$wp_x], $wheel_pic[0][$wp_y], $wheel_pic[0][$wp_w], $wheel_pic[0][$wp_h])
				endif
				$redraw= 0
			endif
		endif;winactive(hgui)
		sleep(40);keep cpu from over heating from this loop process
	until $msg= $gui_event_close
	_SDL_FreeSurface($wheel_surf)
	_SDL_FreeSurface($magnifier_surf)
	If $__SDL_DLL <> -1 Then _SDL_Quit();"Once upon a time... You saw me ;)"
	If $__SDL_DLL_image <> -1 Then _SDL_Shutdown_image()
	if $__SDL_DLL_sge<> - 1 then _SDL_Shutdown_sge()
	if $__SDL_DLL_sprig<> -1 then _SDL_Shutdown_sprig();)
EndFunc;main()

func gui_control_show($start= 0, $end= $gui_control_max-1)
	for $i= $start to $end
		guictrlsetstate($gui_control[$i], $gui_show)
	next
EndFunc;gui_control_show()

func creategui()
	; Combo GUI Controls
	$gui_control[$gc_symbol_comboex]= _GUICtrlComboBoxEx_Create($hgui, "", 40, $hgui_rect[3]-110, 120, 120, $CBS_DROPDOWNLIST);$CBN_SELCHANGE
	$gui_control[$gc_monster_comboex]= _GUICtrlComboBoxEx_Create($hgui,"", 120+40+20, $hgui_rect[3]-110, 120, 120, $CBS_DROPDOWNLIST);$CBS_DROPDOWNLIST

	$gui_control[$gc_location_combo]= guictrlcreatecombo("", 40, $hgui_rect[3]-70, 120)
	$gui_control[$gc_item_combo]= guictrlcreatecombo("", 120+40+20, $hgui_rect[3]-70, 120)

	; Wheel Diagram
	$gui_control[$gc_wheel_diagram_label]= guictrlcreatelabel("", $hgui_rect[2]-175, 0, 175, 20)
	guictrlsetfont(-1, 10, 400)
	guictrlsetbkcolor($gui_control[$gc_wheel_diagram_label], $GUI_BKCOLOR_TRANSPARENT)
	guictrlsetcolor($gui_control[$gc_wheel_diagram_label], 0xFFFFFF)
	; Rotate Left, Right Buttons
	$gui_control[$gc_rotate_input]= guictrlcreateinput("", $hgui_rect[2]-120, 70, 45, 20)
	$gui_control[$gc_rotate_left_button]= guictrlcreatebutton("< Turn", $hgui_rect[2]-175, 70, 50, 19)
	$gui_control[$gc_rotate_right_button]= guictrlcreatebutton("Turn >", $hgui_rect[2]-70, 70, 50, 19)
	; Rotate Whole Wheel Buttons
	$gui_control[$gc_rotate_wheel_surf_input]= guictrlcreateinput("", $hgui_rect[2]-120, 180, 45, 20)
	$gui_control[$gc_rotate_wheel_surf_left_button]= guictrlcreatebutton("< Disk", $hgui_rect[2]-175, 180, 50, 19)
	$gui_control[$gc_rotate_wheel_surf_right_button]= guictrlcreatebutton("Disk >", $hgui_rect[2]-70, 180, 50, 19)

	; Magnifier Button
	$gui_control[$gc_magnifier_button]= guictrlcreatepic(@scriptdir&"\Data\Graphics\Magnifying Glass.bmp", $hgui_rect[2]-170, 230, 46, 46)

	; Adjust button
	$gui_control[$gc_move_up_button]= guictrlcreatebutton("Up", $hgui_rect[2]-120, 310, 50, 20)
	$gui_control[$gc_move_down_button]= guictrlcreatebutton("Down", $hgui_rect[2]-120, 350, 50, 20)
	$gui_control[$gc_move_left_button]= guictrlcreatebutton("Left", $hgui_rect[2]-180, 310, 50, 20)
	$gui_control[$gc_move_right_button]= guictrlcreatebutton("Right", $hgui_rect[2]-60, 310, 50, 20)

	; Seek
	$gui_control[$gc_seek_button]= guictrlcreatebutton("Get Code", 120+120+40+40, $hgui_rect[3]-70, 80, 21)
	guisetstate();show the gui
EndFunc;creategui()

func code_load()
	local $a_surf_size
	local $wheel_node= $gc_monster_comboex

	; Symbol Combo Bmp icons
	 _GUICtrlComboBoxEx_BeginUpdate($gui_control[$gc_symbol_comboex])
	$hImage= _GUIImageList_Create(32, 32, 6)
 	for $i= 0 to $code_x_max-1
		_GUIImageList_AddBitmap($hImage, @scriptdir&"\Data\Graphics\Symbols\"&$i&".bmp")
 	next
 	_GUICtrlComboBoxEx_SetImageList($gui_control[$gc_symbol_comboex], $hImage)

	$file= fileopen(@scriptdir&"\Data\Wheel Codes.txt")
	; Load the Wheel Data base
	for $wheel= 0 to $code_layer_max-1
		if $wheel> 0 then $wheel_node= $gc_symbol_comboex; fileline 1-84, 85-168 wheel[0, 1]
		for $i= 0 to $code_x_max-1
			_GUICtrlComboBoxEx_AddString ($gui_control[$wheel_node], filereadline($file), $i, $i)
			for $ii= 0 to $code_y_max-1
				$wheel_code[$i][$ii][$wheel]= filereadline($file)
			next;ii
		next;i
	next;wheel layer

	_GUICtrlComboBoxEx_EndUpdate($gui_control[$gc_symbol_comboex])
	; Location Labels
	for $i= 0 to $code_x_max-1; fileline 169-180
		guictrlsetdata($gui_control[$gc_location_combo], filereadline($file))
	next
	; Index Chart
	for $i= 0 to $index_chart_max-1; fileline 181-228
		guictrlsetdata($gui_control[$gc_item_combo], filereadline($file))
		for $ii= 0 to $index_chart_data_max-1
			$index_chart[$i][$ii]= int(filereadline($file))
		next;ii
	next;i
	fileclose($file); Wheel Codes.txt
	for $i= 0 to 3; Combo dials
		_GUICtrlComboBox_SetCurSel($gui_control[$i], 0)
	next

	; Wheel_Pic[][]
	$file= fileopen(@scriptdir&"\Data\Wheel Info.txt")
	for $i= 0 to $wheel_max-1
		$wheel_pic[$i][$wp_surf]= _IMG_Load(@scriptdir&"\Data\Graphics\"&$i&".png"); Load the wheel surface
		$a_surf_size= surf_get_size($wheel_pic[$i][$wp_surf]); Get the surface size
		$wheel_pic[$i][$wp_w]= $a_surf_size[0]
		$wheel_pic[$i][$wp_h]= $a_surf_size[1]
		$wheel_pic[$i][$wp_name_label]= filereadline($file); Name string of wheel
		$wheel_pic[$i][$wp_wheel_diagram_color]= filereadline($file);
		$wheel_pic[$i][$wp_x]= filereadline($file);-27; 1
		$wheel_pic[$i][$wp_y]= filereadline($file);-29
	next
	fileclose($file)
EndFunc;code_load()

func wheel_draw()
	_SDL_FillRect($wheel_surf, 0, 0);color surface black
	$wheel_surf_buffer= _SDL_DisplayFormat($wheel_surf)
	if $wheel_surf_a< 0 then $wheel_surf_a+= 360; Normal eyes
	if $wheel_surf_a> 360 then $wheel_surf_a-= 360; Normal eyes
	for $i= 0 to $wheel_max-1
		if $wheel_pic[$i][$wp_rotate]< 0 then $wheel_pic[$i][$wp_rotate]+= 360; Normal eyes
		if $wheel_pic[$i][$wp_rotate]> 360 then $wheel_pic[$i][$wp_rotate]-= 360; Normal eyes
		$surf_rotate= _SDL_CreateRGBSurface($_SDL_SWSURFACE, $wheel_pic[$i][$wp_w], $wheel_pic[$i][$wp_h], 32, 0, 0, 0, 0)
		_sge_transform($wheel_pic[$i][$wp_surf], $surf_rotate, $wheel_pic[$i][$wp_rotate], 1, 1, $wheel_pic[$i][$wp_w]/2, $wheel_pic[$i][$wp_h]/2, $wheel_pic[$i][$wp_w]/2, $wheel_pic[$i][$wp_h]/2, 0)
		_SDL_SetColorKey($surf_rotate, $_SDL_SRCCOLORKEY, _SDL_MapRGB($screen, 0, 0, 0))

		$drect= _SDL_Rect_Create($wheel_pic[$i][$wp_x], $wheel_pic[$i][$wp_y], $wheel_pic[$i][$wp_w], $wheel_pic[$i][$wp_h])

		_SDL_BlitSurface($surf_rotate, 0, $wheel_surf_buffer, $drect)
		_SDL_FreeSurface($surf_rotate)
	next
	$surf_rotate= _SDL_CreateRGBSurface($_SDL_SWSURFACE, $wheel_pic[0][$wp_w], $wheel_pic[0][$wp_h], 32, 0, 0, 0, 0)
	_sge_transform($wheel_surf_buffer, $wheel_surf, $wheel_surf_a, 1, 1, $wheel_pic[0][$wp_w]/2, $wheel_pic[0][$wp_h]/2, $wheel_pic[0][$wp_w]/2, $wheel_pic[0][$wp_h]/2, 0)
	_SDL_BlitSurface($wheel_surf, 0, $screen, 0)
	_SDL_FreeSurface($surf_rotate)
	_SDL_FreeSurface($wheel_surf_buffer)
EndFunc;wheel_draw()

func wheel_diagram_draw()
	guictrlsetdata($gui_control[$gc_wheel_diagram_label], "Selected "&$wheel_cur+1&" "&$wheel_pic[$wheel_cur][$wp_name_label]&" wheel")
	for $i= 0 to $wheel_max-1
		if $i= $wheel_cur then
			_sge_FilledCircle($screen, $wheel_diagram_rect.x+$wheel_diagram_rect.w/2, $wheel_diagram_rect.y+$wheel_diagram_rect.h/2, 50-$i*15, _SDL_MapRGB($screen, 0, 200, 0))
		else
			_sge_FilledCircle($screen, $wheel_diagram_rect.x+$wheel_diagram_rect.w/2, $wheel_diagram_rect.y+$wheel_diagram_rect.h/2, 50-$i*15, $wheel_pic[$i][$wp_wheel_diagram_color])
		endif
	next
EndFunc;wheel_diagram_draw()

func mouseoverrect($x, $y, $w, $h)
	$mousepo= mousegetpos()
	if $mousepo[0]> $x-1 and $mousepo[0]< $x+$w+1 then
		if $mousepo[1]> $y-1 and $mousepo[1]< $y+$h+1 then
			return 1
		endif
	endif
	return 0
EndFunc;mouseoverrect()

func out($output= "");debug tool
	consolewrite(@CRLF&$output);to console new line, value of $output
EndFunc;out()

func surf_get_size($surf)
	local $a_size[2]
	$struct= DllStructCreate($tagSDL_SURFACE, $surf)
	$a_size[0]= DllStructGetData($struct, "w")
	$a_size[1]= DllStructGetData($struct, "h")
	$struct= 0
	return $a_size
EndFunc;surf_get_size()

func code_display()
	$item_id= _GUICtrlComboBox_GetCurSel($gui_control[$gc_item_combo])
	$monster_id= _GUICtrlComboBox_GetCurSel($gui_control[$gc_monster_comboex])
	$location_id= _GUICtrlComboBox_GetCurSel($gui_control[$gc_location_combo])
	out("Item "&$item_id&" Monster "&$monster_id&" Location "&$location_id)
	$x= $index_chart[$item_id][0]+$monster_id-$location_id
	out("x, y "&$x&", "&$index_chart[$item_id][1])
	if $x> $code_x_max-1 then
		out("x was greater")
		$x-= $code_x_max
	endif
	if $x< 0 then
		out("x was less then zero")
		$x+= $code_x_max
	endif

	$code= $wheel_code[$x][$index_chart[$item_id][1]][0]
	if $code= "****" then
		MsgBox(0, "CODE", $code)
		out("Monster Wheel")
		$symbol_id= _GUICtrlComboBox_GetCurSel($gui_control[$gc_symbol_comboex])
		$x= $index_chart[$item_id][0]+$symbol_id-$location_id
		$code= $wheel_code[$x][$index_chart[$item_id][1]][1]
	endif
	MsgBox(0, "CODE", $code)
EndFunc;code_display()

;Rasim: http://stackoverflow.com/questions/402486/how-do-i-recognize-a-drag-select-with-autoit
Func _Mouse_Handler($nCode, $wParam, $lParam)
    If $nCode < 0 Then Return _WinAPI_CallNextHookEx($hHookMouse, $nCode, $wParam, $lParam)
    Switch $wParam
        Case $WM_LBUTTONDOWN
            $mouse_coord = MouseGetPos()
        Case $WM_MOUSEMOVE
			$mouse_moved= 1
            If _IsPressed("01") Then $mouse_drag = 1
		Case $WM_LBUTTONUP
			$mouse_drag= 0
    EndSwitch
    Return _WinAPI_CallNextHookEx($hHookMouse, $nCode, $wParam, $lParam)
EndFunc

func wheel_info_save()
	$file= fileopen(@scriptdir&"\Data\Wheel Info.txt", 2)
	for $i= 0 to $wheel_max-1
		filewriteline($file, $wheel_pic[$i][$wp_name_label]); Name string of wheel
		filewriteline($file, $wheel_pic[$i][$wp_wheel_diagram_color])
		filewriteline($file, $wheel_pic[$i][$wp_x]);-27; 1
		filewriteline($file, $wheel_pic[$i][$wp_y])
	next
	fileclose($file)
EndFunc;wheel_info_save()

func wheel_info_load()
	$file= fileopen(@scriptdir&"\Data\Wheel Info.txt")
	for $i= 0 to $wheel_max-1
		$wheel_pic[$i][$wp_surf]= _IMG_Load(@scriptdir&"\Data\Graphics\"&$i&".bmp"); Load the wheel surface
		$a_surf_size= surf_get_size($wheel_pic[$i][$wp_surf]); Get the surface size
		$wheel_pic[$i][$wp_w]= $a_surf_size[0]
		$wheel_pic[$i][$wp_h]= $a_surf_size[1]
		$wheel_pic[$i][$wp_name_label]= filereadline($file); Name string of wheel
		$wheel_pic[$i][$wp_wheel_diagram_color]= int(filereadline($file));
		$wheel_pic[$i][$wp_x]= int(filereadline($file));-27; 1
		$wheel_pic[$i][$wp_y]= int(filereadline($file));-29
	next
	fileclose($file)
EndFunc;wheel_info_load()

func keyreleased($key, $key2= "", $key3= "", $key4= "")
	while _ispressed($key) or _ispressed($key2) or _ispressed($key3) or _ispressed($key4)
		sleep(20)
	wend
EndFunc;keyreleased()

func wheel_diagram_mouse_over()
	if mouseoverrect($wheel_diagram_rect.x, $wheel_diagram_rect.y, $wheel_diagram_rect.w, $wheel_diagram_rect.h)= 1 then
		if $mousepo[1]<= 70 or $mousepo[1]>= 70+20 then; If not over rotation gui controls, < button, input angle, button >
			$mouse_color= _SPG_GetPixel($screen, $mousepo[0], $mousepo[1])
			for $i= 0 to $wheel_max-1
				if $mouse_color= $wheel_pic[$i][$wp_wheel_diagram_color] then
					$wheel_cur= $i
					$redraw= 2
					return 1
				endif
			next
		endif;not over gui controls
	endif;over wheel_diagram
	return 0
EndFunc;

func wheel_drag(byref $mousepo_last, $mode= 0)
	if $mouse_moved= 1 then
		$mousepo= mousegetpos()
		$x= ($mousepo[0]-$mousepo_last[0])/5
		if $mode= 0 then
			$wheel_pic[$wheel_cur][$wp_rotate]+= $x
		else
			$wheel_surf_a+= $x
		endif
		$redraw= 1
		$mousepo_last= $mousepo
	endif
	$mouse_moved= 0
EndFunc;

func wheel_seek_position()
	for $i= 0 to $wheel_max-2; Check for combo selection differances for the comboex
		if $wheel_pic[$i][$wp_last_id]<> _GUICtrlComboBox_GetCurSel($gui_control[$i]) then; Spin wheel to seek destination
			$wheel_pic[$i][$wp_spin_to]= 360-(_GUICtrlComboBox_GetCurSel($gui_control[$i])*(360/$code_x_max))
			if $wheel_pic[$i][$wp_spin_to]= 360 then $wheel_pic[$i][$wp_spin_to]= 0
			$wheel_pic[$i][$wp_spin]= 1
			$wheel_pic[$i][$wp_last_id]= _GUICtrlComboBox_GetCurSel($gui_control[$i])
		endif
	next
	for $i= 0 to $wheel_max-1
		if $wheel_pic[$i][$wp_spin]= 1 then
			if $wheel_pic[$i][$wp_rotate]<> $wheel_pic[$i][$wp_spin_to] then
				if $redraw= 0 then $redraw= 1
				if abs($wheel_pic[$i][$wp_rotate]-$wheel_pic[$i][$wp_spin_to])< 5 then
					$wheel_pic[$i][$wp_rotate]= $wheel_pic[$i][$wp_spin_to]
					$wheel_pic[$i][$wp_spin]= 0
				else
					$wheel_pic[$i][$wp_rotate]-= 4
				endif
			endif
		endif;spin= 1
	next
EndFunc;

;Adapted from Melba23's example: http://www.autoitscript.com/forum/topic/123089-input-with-only-numbers-and-decimal-point/?p=854887
Func MY_WM_COMMAND($hWnd, $iMsg, $wParam, $lParam); Format angle gui input fields
    Local $iIDFrom = BitAND($wParam, 0xFFFF);LoWord
    Local $iCode = BitShift($wParam, 16)    ;HiWord
    If ($iIDFrom = $gui_control[$gc_rotate_input] or $iIDFrom = $gui_control[$gc_rotate_wheel_surf_input]) And $iCode = $EN_CHANGE Then
		$Read_Input = GUICtrlRead($iIDFrom)
		If StringRegExp($Read_Input, '[^\d.-]|([{0-9,1}^\A-])[^\d.]') Then $Read_Input = StringRegExpReplace($Read_Input, '[^\d.-]|([{0-9,1}^\A-])[^\d.]', '\1')
		$Point1 = StringInStr($Read_Input, ".", 0)
		$Point2 = StringInStr($Read_Input, ".", 0, 2)
		If $Point2 <> 0 Then $Read_Input = StringLeft($Read_Input, $Point2 - 1)
		If $Point1 <> 0 Then $Read_Input = StringLeft($Read_Input, $Point1 + $iDecimal)
		GUICtrlSetData($iIDFrom, $Read_Input)
    EndIf
EndFunc;==>_WM_COMMAND